import OOPLS.Maze;
import OOPLS.MazeConfigurationDialog;
import OOPLS.MazeHelpDialog;
import OOPLS.MazePanel;
import java.awt.EventQueue;
import java.awt.FileDialog;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.JFrame;
import javax.swing.JMenu;
import javax.swing.JMenuBar;
import javax.swing.JMenuItem;
import java.awt.FileDialog;
import java.awt.event.WindowEvent;

public class MazeApplication extends JFrame {
    MazePanel mp = new MazePanel();
    JMenuBar menuBar = new JMenuBar();
    JMenu fileMenu = new JMenu("File");
    JMenuItem saveItem = new JMenuItem("Save");
    JMenuItem saveAsItem = new JMenuItem("Save As");
    JMenuItem loadItem = new JMenuItem("Open");
    JMenuItem exitItem = new JMenuItem("Exit");
    JMenuItem newItem = new JMenuItem("New");    
    JMenu editMenu = new JMenu("Edit");
    JMenuItem eraseSolutionItem = 
        new JMenuItem("Erase solution");
    JMenuItem configurationItem = 
        new JMenuItem("Reconfigure maze");
    JMenuItem helpMenu = new JMenuItem("Help");
    String filename = "";
    public MazeApplication() {
        setBounds(0,0,700,500);
        initComponents();
    }
    public void initComponents() {
        fileMenu.add(newItem);
        newItem.addActionListener(new ActionListener() {
            public void actionPerformed(ActionEvent e) {
                mp.newMaze();
                filename = "";
                setTitle("");
                repaint();
            }
        });
        fileMenu.add(saveItem);
        saveItem.addActionListener(new ActionListener() {
            public void actionPerformed(ActionEvent e) {
                if (filename.length() == 0) saveAs();
                else mp.saveMaze(filename);
            } 
        });
        fileMenu.add(saveAsItem);
        saveAsItem.addActionListener(new ActionListener() {
            public void actionPerformed(ActionEvent e) {
                saveAs();
            } 
        });
        fileMenu.add(loadItem);
        loadItem.addActionListener(new ActionListener() {
            public void actionPerformed(ActionEvent e) {
                FileDialog lfd = 
                        new FileDialog(MazeApplication.this,
                                 "Load Maze",FileDialog.LOAD);
                lfd.setFile("*.maz");
                lfd.setVisible(true);
                if (lfd.getDirectory() != null && 
                    lfd.getFile() != null && 
                    lfd.getFile().length() > 0) {
                    String oldFilename = filename;
                    filename = lfd.getDirectory()+lfd.getFile();
                    if (mp.openMaze(filename)) setTitle(filename);
                    else filename = oldFilename;
                }
                mp.repaint();
            }
        });
        fileMenu.add(exitItem);
        exitItem.addActionListener(new ActionListener() {
            public void actionPerformed(ActionEvent e) { 
                dispatchEvent(
                    new WindowEvent(
                        MazeApplication.this,
                        WindowEvent.WINDOW_CLOSING));
            }
        });
        menuBar.add(fileMenu);
        editMenu.add(eraseSolutionItem);
        eraseSolutionItem.addActionListener(new ActionListener() {
            public void actionPerformed(ActionEvent e) {
                mp.eraseSolution();
                mp.repaint();
            } 
        });
        editMenu.add(configurationItem);
        configurationItem.addActionListener(new ActionListener() {
            public void actionPerformed(ActionEvent e) {
                Maze oldMaze = mp.getMaze();
                MazeConfigurationDialog mcd = 
                        new MazeConfigurationDialog(mp);
                mcd.setModal(true);
                mcd.setVisible(true);
                if (mp.getMaze() != oldMaze) {
                    filename = "";
                    setTitle("");
                }
                mp.repaint();
            } 
        });
        menuBar.add(editMenu);
        helpMenu.addActionListener(new ActionListener() {
            public void actionPerformed(ActionEvent e) {
                MazeHelpDialog helpDialog = new MazeHelpDialog();
                helpDialog.setVisible(true);
                mp.repaint();
            } 
        });
        menuBar.add(helpMenu);
        setJMenuBar(menuBar);
        setDefaultCloseOperation(EXIT_ON_CLOSE);
        getContentPane().add(mp);
    }
    void saveAs() {
        FileDialog sfd = new FileDialog(
               MazeApplication.this,"Save Maze", FileDialog.SAVE);
        if (filename.length() == 0) filename = "untitled.maz";
        sfd.setFile(filename);
        sfd.setVisible(true);
        if (sfd.getDirectory() != null && sfd.getFile() != null
            && sfd.getFile().length() > 0) {
                String oldFilename = filename;
                filename = sfd.getDirectory() + sfd.getFile();
                if (!filename.substring(
                    filename.length()-4).equals(".maz"))
                        filename += ".maz";
                if (mp.saveMaze(filename)) 
                    setTitle(filename);
                else filename = oldFilename;
        }
        mp.repaint();
    }

}